/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.block;

import com.nyfaria.numismaticoverhaul.block.PiggyBankBlockEntity;
import com.nyfaria.numismaticoverhaul.init.BlockInit;
import com.nyfaria.numismaticoverhaul.init.SoundInit;
import com.nyfaria.numismaticoverhaul.init.TagInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PiggyBankBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final VoxelShape NORTH_SHAPE = Stream.of(Block.m_49796_((double)7.0, (double)2.0, (double)4.0, (double)9.0, (double)4.0, (double)5.0), Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)6.0, (double)1.0, (double)7.0), Block.m_49796_((double)5.0, (double)0.0, (double)9.0, (double)6.0, (double)1.0, (double)11.0), Block.m_49796_((double)10.0, (double)0.0, (double)9.0, (double)11.0, (double)1.0, (double)11.0), Block.m_49796_((double)10.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)7.0)).reduce(Shapes::m_83110_).get();
    private static final VoxelShape SOUTH_SHAPE = Stream.of(Block.m_49796_((double)7.0, (double)2.0, (double)11.0, (double)9.0, (double)4.0, (double)12.0), Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.m_49796_((double)10.0, (double)0.0, (double)9.0, (double)11.0, (double)1.0, (double)11.0), Block.m_49796_((double)10.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)7.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)6.0, (double)1.0, (double)7.0), Block.m_49796_((double)5.0, (double)0.0, (double)9.0, (double)6.0, (double)1.0, (double)11.0)).reduce(Shapes::m_83110_).get();
    private static final VoxelShape EAST_SHAPE = Stream.of(Block.m_49796_((double)11.0, (double)2.0, (double)7.0, (double)12.0, (double)4.0, (double)9.0), Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.m_49796_((double)9.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)6.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)7.0, (double)1.0, (double)6.0), Block.m_49796_((double)5.0, (double)0.0, (double)10.0, (double)7.0, (double)1.0, (double)11.0), Block.m_49796_((double)9.0, (double)0.0, (double)10.0, (double)11.0, (double)1.0, (double)11.0)).reduce(Shapes::m_83110_).get();
    private static final VoxelShape WEST_SHAPE = Stream.of(Block.m_49796_((double)4.0, (double)2.0, (double)7.0, (double)5.0, (double)4.0, (double)9.0), Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)10.0, (double)7.0, (double)1.0, (double)11.0), Block.m_49796_((double)9.0, (double)0.0, (double)10.0, (double)11.0, (double)1.0, (double)11.0), Block.m_49796_((double)9.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)6.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)7.0, (double)1.0, (double)6.0)).reduce(Shapes::m_83110_).get();

    public PiggyBankBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof MenuProvider) {
            MenuProvider factory = (MenuProvider)blockEntity;
            player.m_5893_(factory);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        FallingBlockEntity fallingBlock;
        if (entity instanceof FallingBlockEntity && (fallingBlock = (FallingBlockEntity)entity).m_31980_().m_204336_(TagInit.VERY_HEAVY_BLOCKS) && !world.f_46443_) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof PiggyBankBlockEntity) {
                PiggyBankBlockEntity piggyBank = (PiggyBankBlockEntity)blockEntity;
                Containers.m_19010_((Level)world, (BlockPos)pos.m_121945_(((Direction)world.m_8055_(pos).m_61143_((Property)f_54117_)).m_122424_()), piggyBank.inventory());
            }
            world.m_7471_(pos, false);
            world.m_5594_(null, pos, (SoundEvent)SoundInit.PIGGY_BANK_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.m_142072_(world, state, pos, entity, fallDistance);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PiggyBankBlockEntity) {
            PiggyBankBlockEntity piggyBank = (PiggyBankBlockEntity)blockEntity;
            if (player.m_7500_() && !world.f_46443_ && !piggyBank.inventory().stream().allMatch(ItemStack::m_41619_)) {
                ItemStack stack = new ItemStack((ItemLike)BlockInit.PIGGY_BANK.get());
                piggyBank.m_187476_(stack);
                ItemEntity var = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                var.m_32060_();
                world.m_7967_((Entity)var);
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof PiggyBankBlockEntity) {
            PiggyBankBlockEntity piggyBank = (PiggyBankBlockEntity)((Object)object);
            ItemStack tool = (ItemStack)builder.m_78982_(LootContextParams.f_81463_);
            if (tool != null && tool.m_41788_() && Objects.equals(tool.m_41786_().getString(), "Hammer")) {
                builder.m_78962_().m_5594_(null, piggyBank.m_58899_(), (SoundEvent)SoundInit.PIGGY_BANK_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_7381_(state, builder));
                piggyBank.inventory().stream().filter(stack -> !stack.m_41619_()).forEach(drops::add);
                return drops;
            }
            builder.m_78979_(new ResourceLocation("contents"), (context, consumer) -> piggyBank.inventory().forEach(consumer));
        }
        return super.m_7381_(state, builder);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PiggyBankBlockEntity(pos, state);
    }
}

